# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 6
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR6_strategy.txt
# LLM Suggested Fallback: Not Provided

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR6(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Check for deterministic opponent strategies
    always_cooperate = "always cooperate" in opponent_program_code.lower() or "return 'C'" in opponent_program_code.lower()
    always_defect = "always defect" in opponent_program_code.lower() or "return 'D'" in opponent_program_code.lower()
    
    if always_cooperate and current_round >= 1:
        return "D"
    if always_defect:
        return "D"
    
    if current_round == 1:
        return "C"
    elif current_round == 2:
        return "D"
    elif 3 <= current_round <= 7:
        if len(opp_history) >= 2 and opp_history[0] == "C" and opp_history[1] == "C":
            return "D"
        elif len(opp_history) >= 2 and opp_history[1] == "D":
            if current_round % 2 == 1:
                return "C"
            else:
                return "D"
        else:
            return "D"
    elif current_round >= 8:
        return "D"
    
    # Fallback to Tit-for-Tat if no other conditions met
    if len(opp_history) > 0:
        return opp_history[-1]
    else:
        return "C"